Include([[Data/levels/include/level_utils.lua]])

Level =
{
	MapSkinFilename = LevelUtils.PickRandomChoice(LevelUtils.GetAllSkinFilenames()),
	MapGenScript = function ()
	
		MapGeometry:Randomize(60000)
		MapEntities:SetParameters(LevelUtils.MapGenDefaults)
		MapEntities:GenerateLocations()
	
		--Capture point placement
		for i=1, 4 do
			MapEntities:PlaceCapPoint(false, -1, 2, true, LevelUtils.MapGenDefaults.CapPtExclusionRadius, "");
		end

		for i=1, 4 do
			MapEntities:PlaceCapPoint(false, -1, 3, true, LevelUtils.MapGenDefaults.CapPtExclusionRadius, "");
		end
		
		MapEntities:PlaceCapPoint(false, -1, 0, false, LevelUtils.MapGenDefaults.CapPtExclusionRadius, "");
		--local homeBase = MapEntities:PlaceCapPoint(true, -1, 0, false, 90.0, "");
		local homePos = vect2f()
		local homePlaced = MapEntities:GetStartingPlace(homePos, 90.0)
        
        if homePlaced then
            GameWorld:AddMarines(homePos, GameWorld:GetStartingTeamSize())
            GameWorld:ResetCamera(homePos)
            --GameWorld:FocusCameraOn(homeBase)
            
            local bunker = GameWorld:CreateEntity("PropBuilding", "xenoBunker", homePos)
            
            GameWorld:RegisterRaidTarget(bunker)
            GameWorld:RegisterRespawnSource(bunker)
            
            local building = bunker:ToCHumanBuilding()
            building:CompleteBuilding()
            
            BunkerLostScript:OnBunkerCreated()
		end
		
		--Alien support structs
		MapEntities:PlaceEnemyStuctures(15.0, 5.0);
		
		--Place crates
		for i=1, 3 do
			MapEntities:PlaceBPCrate(20.0, 60.0, 15.0);
		end
		
		for i=1, 3 do
			MapEntities:PlaceAPCrate(14.0, 20.0, 6.0);
		end		
	end,
	
	Parameters =
	{
		MarineCount 		= 5,
		MaxHiveLevel 		= 4,
		MaxSpawnRate 		= 30.0,
		StartBPMultiplier 	= 1.0,
		BPGainMultiplier    = 1.0,
		
		DefaultHiveTowerCount = 10,
	},
	Rules = 
	{
		AutoCapture 	= true,		    --Destroying hives automatically counts as a capture
		NoPushback		= false,		   --Can the player's points be captured?
		NoTowerRespawn  = true,         --Can the hive towers respawn?
		WeakenHiveOnCap = false,        --Do captures halve defensive strength?
		DisableLockdown = false,        --Turn off emergency help is player is behind
	},
	Mutations =
	{
		CapturesPerMutation = 1,
		MaxMutations = 8,
		Default = [[inactive]],
		Active =
		{
		},
		Queue =
		{
		},
		Disabled =
		{
		},
		Randomize = true
	},
	MarineUpgrades = 
	{
		--Default = [[inactive]],
		--FreeUpgradesDefault = [[active]],
		Active =
		{
		},
		Inactive =
		{
		},	
		Locked =
		{
		},			
	},
	
	GetLevelReward = function ()
		return GameWorld:GetStat([[ST_XENOCIDE_REWARD]])
	end
}

XenoTimer = nil
------------------------------------------------------------------------------- Level Init
LevelInit = LevelUtils.MakeGoal(
	nil,
	{[[NT_BEGIN_GAME]]},
	function (self, p_type, p_entId, p_pos, p_other)		
		XenoTimer =
        LevelUtils.CreateXenocideTimer(120000, MutationWatcher.baseTimer,
                                                     	function ()
															GameWorld:GameOver(true)		
															CaptureAllBonus:Disable()
														end)
		LevelUtils.CreateXenocideRewardCounter()
		CaptureAllBonus:Enable()
		
		
		--ScriptMgr:DoDelayedCall(1000, function () GameWorld:MakeAnnouncement("Evacuation\nIn 2 Minutes"); end)
		
		self:Disable()
	end)
LevelInit:Enable()

------------------------------------------------------------------------------- Tracked objective for killing everything
local bonusSize = 4000
CaptureAllBonus = LevelUtils.MakeGoal(
	function (self)
		GameWorld:SetUIVisibility("Objectives", true)
		local commaSeparatedValue = string.gsub(bonusSize, "(%d)(%d%d%d)$", "%1,%2", 1)
		GameWorld:AddObjective("bonusobj", "Kill all hives for a $" .. commaSeparatedValue .. " bonus")
		
		--local text_hdl = GameWorld:ShowText("We're short on time squad!\nKill all you can before the clock runs out.\nBonus pay for wiping the area clean, you hear?", "Sarge")
		--ScriptMgr:DoDelayedCall(8000, function () text_hdl:ClearText(); end)
	end,
	
	{[[NT_ALL_POINTS_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ChangeObjectiveStatus("bonusobj", [[complete]])
	
		local commaSeparatedValue = string.gsub(bonusSize, "(%d)(%d%d%d)$", "%1,%2", 1)
		GameWorld:MakeAnnouncement("$" .. commaSeparatedValue .. "\nBonus Earned")
		GameWorld:ChangeStat("ST_XENOCIDE_REWARD", bonusSize)
	
		GameWorld:ClearText()
		GameWorld:GameOver(true)
	
	    BunkerLostScript:Disable()
		self:Disable()
	end)
	
	
------------------------------------------------------------------------------- Mutation has happened!
MutationWatcher = LevelUtils.MakeGoal(
	function (self)
	
		local rewardValue = tonumber(GameWorld:GetParam("ContractReward"))
		if not rewardValue then rewardValue = 5000 end
	
	    self.multiplier         = rewardValue / 5000 * 0.3
	    if XenoRewardMultiplier ~= nil then
	        self.multiplier = self.multiplier * XenoRewardMultiplier
	    end
	    
	    self.baseTimer          = 50000
	    self.timerReward        = self.baseTimer
	    self.KillReward_Mobile  = 1*self.multiplier
        self.KillReward_Tower   = 100*self.multiplier
        self.KillReward_Hive    = 2000*self.multiplier
	    bonusSize = math.floor(bonusSize*self.multiplier)
	
        GameWorld:SetParam("KillReward_Mobile", self.KillReward_Mobile*self.multiplier)
        GameWorld:SetParam("KillReward_Tower", self.KillReward_Tower*self.multiplier)
        GameWorld:SetParam("KillReward_Hive", self.KillReward_Hive*self.multiplier)
	
	end,
	
	{[[NT_MUTATION_EVOLVED]]},
	function (self, p_type, p_entId, p_pos, p_other)	
		
		local mutationInfo = LevelUtils.mutationWeights[p_other]
		if mutationInfo == nil then
		    return
        end
		
		bonusSize = math.floor(bonusSize + (mutationInfo.hivesReward + mutationInfo.towersReward*10 + mutationInfo.mobilesReward*750)*self.multiplier)
	    self.timerReward        = self.timerReward + 10000 + mutationInfo.timer*1000 --math.max(self.baseTimer + mutationInfo.timer*1000, self.timerReward)
	    self.KillReward_Mobile  = self.KillReward_Mobile + mutationInfo.mobilesReward*self.multiplier
        self.KillReward_Tower   = self.KillReward_Tower + mutationInfo.towersReward*self.multiplier
        self.KillReward_Hive    = self.KillReward_Hive + mutationInfo.hivesReward*self.multiplier
        
		local commaSeparatedValue = string.gsub(bonusSize, "(%d)(%d%d%d)$", "%1,%2", 1)
        GameWorld:ChangeObjectiveText("bonusobj", "Kill all hives for a $" .. commaSeparatedValue .. " bonus")
        XenoTimer:ChangeCaptureIncrement(self.timerReward)
        GameWorld:SetParam("KillReward_Mobile", self.KillReward_Mobile)
        GameWorld:SetParam("KillReward_Tower", self.KillReward_Tower)
        GameWorld:SetParam("KillReward_Hive", self.KillReward_Hive)
		
	end)
MutationWatcher:Enable()

------------------------------------------------------------------------------- Capture Script
CaptureScript = LevelUtils.MakeGoal(
	nil,
	
	{[[NT_POINT_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		local bunker = GameWorld:CreateEntity("PropBuilding", "xenoBunker", p_pos)
		GameWorld:RegisterRaidTarget(bunker)
		GameWorld:RegisterRespawnSource(bunker)
		
		DoAirstrike(p_pos)
		
		BunkerLostScript:OnBunkerCreated()
	end) 
CaptureScript:Enable()

-- Do a single airstrike
function DoAirstrike(p_strikePos)
    local dir = vect2f(1.0, 0.0)
    dir:Rotate(GetRandomRange(0.0, math.pi*2))
   
    local chopper = GameWorld:SpawnChopper(dir, p_strikePos)    
    chopper:SetMission(ChopperOrder.CO_AIRSTRIKE_MISSILE, p_strikePos, "")
end

------------------------------------------------------------------------------- Bunker lost 
BunkerLostScript = LevelUtils.MakeGoal(
	function (self)
        self.bunkers_intact = 0
        self.bunker_reward_table = {}  
    end,
	
	{[[NT_ENTITY_DESTROYED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		
        if p_entId ~= "xenoBunker" then
            return
        end

        self.bunkers_intact = self.bunkers_intact - 1

        if self.bunkers_intact <= 0 then
            GameWorld:GameOver(true)
            CaptureAllBonus:Disable()
        else
            local curReward = GameWorld:GetStat([[ST_XENOCIDE_REWARD]])
            local penalty = self.bunker_reward_table[#self.bunker_reward_table]
            penalty = math.min(penalty, curReward)
            penalty = math.floor(penalty)
            
            table.remove(self.bunker_reward_table)

            GameWorld:ChangeStat([[ST_XENOCIDE_REWARD]], -penalty)
			
			local commaSeparatedValue = string.gsub(penalty, "(%d)(%d%d%d)$", "%1,%2", 1)
            GameWorld:MakeAnnouncement("BUNKER DOWN\n-$" .. commaSeparatedValue)
        end
	end,
	
	function (self)
	end)
BunkerLostScript:Enable()

function BunkerLostScript:OnBunkerCreated()

    self.bunkers_intact = self.bunkers_intact + 1
    
    local penalty = MutationWatcher.KillReward_Mobile*500 +
                    MutationWatcher.KillReward_Tower*10 +
                    MutationWatcher.KillReward_Hive;
    
    table.insert(self.bunker_reward_table, penalty)
    
end